
#include "c4d_listview.h"
#include "c4d_general.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "c4d_baseselect.h"




GeListView::GeListView(void)
{
	cd = NULL;
	lv = (_GeListView*)C4DOS.Cu->GeListView_Alloc();
}

GeListView::~GeListView(void)
{
	C4DOS.Cu->GeListView_Free(lv);
	lv = NULL;
	cd = NULL;
}

void GeListView::LvCallBack(LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col,void *data1)
{
}

LONG GeListView::LvCallBackLong(void *secret,LONG cmd,LONG line,LONG col,void *data1)
{
	LONG res_type = 0;
	void *result = NULL;
	LvCallBack(res_type,result,secret,cmd,line,col,data1);
	if (res_type != LV_RES_LONG) return 0;
	return (LONG)result;
}

void GeListView::LvSuperCall(LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col)
{
	C4DOS.Cu->GeListView_LvSuperCall(lv,res_type,result,secret,cmd,line,col);
}

void GeListView::Redraw(void)
{
	C4DOS.Cu->GeListView_Redraw(lv);
}

void GeListView::DataChanged(void)
{
	C4DOS.Cu->GeListView_DataChanged(lv);
}

Bool GeListView::ExtractMouseInfo(void *secret,MouseDownInfo &info,LONG size)
{
	return C4DOS.Cu->GeListView_ExtractMouseInfo(lv,secret,info,size);
}

Bool GeListView::ExtractDrawInfo(void *secret,DrawInfo &info,LONG size)
{
	return C4DOS.Cu->GeListView_ExtractDrawInfo(lv,secret,info,size);
}

Bool GeListView::SendParentMessage(const BaseContainer &msg)
{
	return C4DOS.Cu->GeListView_SendParentMessage(lv,&msg);
}

LONG GeListView::GetId(void)
{
	return C4DOS.Cu->GeListView_GetId(lv);
}

void ListViewCallBackFunc(LONG &res_type,void *&result,void *userdata,void *secret,LONG cmd,LONG line,LONG col,void *data1)
{
	GeListView *lv = (GeListView*)userdata;
	if (lv) lv->LvCallBack(res_type,result,secret,cmd,line,col,data1);
}


Bool GeListView::AttachListView(GeDialog *cd,LONG id)
{
	return C4DOS.Cu->GeListView_Attach(lv,cd->Get(),id,ListViewCallBackFunc,this);
}


SimpleListView::SimpleListView()
{
	C4DOS.Cu->GeListView_Free(lv);
	lv = (_GeListView*)C4DOS.Cu->SimpleListView_Alloc();
}

SimpleListView::~SimpleListView()
{
}

Bool SimpleListView::SetLayout(LONG columns,const BaseContainer &data)
{
	return C4DOS.Cu->SimpleListView_SetLayout((_SimpleListView*)lv,columns,data);
}

Bool SimpleListView::SetItem(LONG id,const BaseContainer &data)
{
	return C4DOS.Cu->SimpleListView_SetItem((_SimpleListView*)lv,id,data);
}

Bool SimpleListView::GetItem(LONG id,BaseContainer *data)
{
	return C4DOS.Cu->SimpleListView_GetItem((_SimpleListView*)lv,id,data);
}

LONG SimpleListView::GetItemCount(void)
{
	return C4DOS.Cu->SimpleListView_GetItemCount((_SimpleListView*)lv);
}

Bool SimpleListView::GetItemLine(LONG num,LONG *id,BaseContainer *data)
{
	return C4DOS.Cu->SimpleListView_GetItemLine((_SimpleListView*)lv,num,id,data);
}

Bool SimpleListView::RemoveItem(LONG id)
{
	return C4DOS.Cu->SimpleListView_RemoveItem((_SimpleListView*)lv,id);
}

void SimpleListView::LvCallBack(LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col,void *data1)
{
}

LONG SimpleListView::GetSelection(BaseSelect *selection)
{
	return C4DOS.Cu->SimpleListView_GetSelection((_SimpleListView*)lv,selection);
}

Bool SimpleListView::SetSelection(BaseSelect *selection)
{
	return C4DOS.Cu->SimpleListView_SetSelection((_SimpleListView*)lv,selection);
}

Bool SimpleListView::SetProperty(LONG id,LONG val)
{
	return C4DOS.Cu->SimpleListView_SetProperty((_SimpleListView*)lv,id,val);
}

LONG SimpleListView::GetProperty(LONG id)
{
	return C4DOS.Cu->SimpleListView_GetProperty((_SimpleListView*)lv,id);
}

